@extends('admin.admin_dashboard')
@section('admin')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <div class="page-content">
        <h1 class="h3 mb-2 text-gray-800">USER LIST</h1>

        <div class="card shadow mb-1">
            @if (session()->has('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            @if (session()->has('error'))
                <div class="alert alert-danger mb-1">
                    {{ session('error') }}
                </div>
            @endif

            <div class="container-fluid">
                <div class="card-body">


                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" style="width:100%">
                            <table id="dataTableExample" class="table table-striped table-bordered" style="width:100%">

                                <thead>
                                    <tr class="align-middle">
                                        <th>#</th>
                                        <th scope="col" style="text-align: center;">Name</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Mobile</th>
                                        <th scope="col">Balance</th>
                                        <th scope="col">Created At</th>
                                        <th scope="col">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($users as $index => $user)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>
                                                <a
                                                    href="{{ route('admin.users.wallet-history', $user->id) }}">{{ $user->name }}</a>
                                            </td>

                                            <td>{{ $user->email }}</td>
                                            <td>{{ $user->phone }}</td>
                                            <td class="user-balance" data-id="{{ $user->id }}">{{ $user->balance }}</td>
                                            <td>{{ $user->created_at->format('d-m-y') }}</td>
                                            <td>
                                                <button class="btn btn-warning btn-sm edit-balance"
                                                    data-id="{{ $user->id }}" data-balance="{{ $user->balance }}"
                                                    data-bs-toggle="modal" data-bs-target="#editBalanceModal">
                                                    <i data-feather="edit"></i> Balance
                                                </button>

                                                <button class="btn btn-info btn-sm edit-user" data-id="{{ $user->id }}"
                                                    data-name="{{ $user->name }}" data-email="{{ $user->email }}"
                                                    data-phone="{{ $user->phone }}" data-bs-toggle="modal"
                                                    data-bs-target="#editUserModal">
                                                    <i data-feather="lock"></i> Edit
                                                </button>
                                                @if ($user->blocked)
                                                    <a href="{{ route('admin.unblockUser', $user->id) }}"
                                                        class="btn btn-success btn-sm">
                                                        <i data-feather="unlock"></i> Unblock
                                                    </a>
                                                @else
                                                    <a href="{{ route('admin.blockUser', $user->id) }}"
                                                        class="btn btn-danger btn-sm">
                                                        <i data-feather="lock"></i> Block
                                                    </a>
                                                @endif

                                            </td>


                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-3">
                        {{ $users->links() }}
                    </div>


                </div>
            </div>
        </div>
    </div>


    <!-- Edit Balance Modal -->
    <div class="modal fade" id="editBalanceModal" tabindex="-1" aria-labelledby="editBalanceModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editBalanceModalLabel">Edit Wallet Balance</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="updateBalanceForm">
                    <div class="modal-body">
                        <input type="hidden" name="user_id" id="user_id" value="">
                        <div class="form-group">
                            <label for="balance">Wallet Balance</label>
                            <input type="number" class="form-control" name="amount" id="amount" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Update Balance</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit User Modal -->
    <div class="modal fade" id="editUserModal" tabindex="-1" aria-labelledby="editUserModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editUserModalLabel">Edit User Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editUserForm">
                    <div class="modal-body">
                        <input type="hidden" name="user_id" id="edit_user_id" value="">
                        <div class="form-group">
                            <label for="edit_name">Name</label>
                            <input type="text" class="form-control" name="name" id="edit_name" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_email">Email</label>
                            <input type="email" class="form-control" name="email" id="edit_email" required>
                        </div>
                        <div class="form-group">
                            <label for="edit_phone">Phone</label>
                            <input type="text" class="form-control" name="phone" id="edit_phone" required>
                        </div>

                        <!-- Password Reset Field (Inside Edit User Modal) -->
                        <div class="form-group">
                            <label for="edit_password">New Password (Optional)</label>
                            <div class="input-group">
                                <input type="password" class="form-control" name="password" id="edit_password">
                                <span class="input-group-text bg-light toggle-password" style="cursor: pointer;">
                                    <i data-feather="eye" id="togglePasswordIcon"></i>
                                </span>
                            </div>
                        </div>


                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Update User</button>
                    </div>
                </form>
            </div>
        </div>
    </div>







    <script>
        $(document).ready(function() {
            feather.replace(); // Initialize Feather Icons

            $('.toggle-password').click(function() {
                let passwordField = $('#edit_password');
                let icon = $('#togglePasswordIcon');

                if (passwordField.attr('type') === 'password') {
                    passwordField.attr('type', 'text');
                    icon.attr('data-feather', 'eye-off'); // Change icon to eye-off
                } else {
                    passwordField.attr('type', 'password');
                    icon.attr('data-feather', 'eye'); // Change icon back to eye
                }

                feather.replace(); // Refresh icons
            });
        });
    </script>


    <script>
        $(document).ready(function() {


          // Handle balance edit modal
          $('.edit-balance').click(function() {
                $('#user_id').val($(this).data('id'));
                $('#amount').val(''); 
            });

            // Handle user details edit modal
            $('.edit-user').click(function() {
                $('#edit_user_id').val($(this).data('id'));
                $('#edit_name').val($(this).data('name'));
                $('#edit_email').val($(this).data('email'));
                $('#edit_phone').val($(this).data('phone'));
            });

            // Handle password reset modal
            $('.reset-password').click(function() {
                $('#reset_user_id').val($(this).data('id'));
            });

            // Generic function to handle AJAX requests
            function sendAjaxRequest(form, url) {
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: form.serialize(),
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.success);
                            $('#editUserModal, #editBalanceModal, #resetPasswordModal').modal('hide');

                            // Reload page after 2 seconds
                            setTimeout(function() {
                                location.reload();
                            }, 1000); // 2000ms = 2 seconds


                        } else {
                            toastr.error("Unexpected response from the server.");
                        }
                    },
                    error: function(xhr, status, error) {
                        toastr.error('Error occurred. Try again.');
                    }
                });
            }

          // Handle balance update form submission
          $('#updateBalanceForm').submit(function(e) {
                e.preventDefault();
                console.log($(this).serialize()); // Debug: Check form data
                sendAjaxRequest($(this), '{{ route('admin.update.balance') }}');
            });

            // Handle user details update form submission
            $('#editUserForm').submit(function(e) {
                e.preventDefault();
                sendAjaxRequest($(this), '{{ route('admin.update-user') }}');
            });

            // Handle password reset form submission
            $('#resetPasswordForm').submit(function(e) {
                e.preventDefault();
                sendAjaxRequest($(this), '{{ route('admin.reset-password') }}');
            });
        });
    </script>
@endsection
