@extends('admin.admin_dashboard')
@section('admin')

<div class="page-content">
        <h1 class="h3 mb-4 text-gray-800">Edit Slider</h1>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('sliders.update', $slider) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="form-group">
                <label for="image">Image</label>
                <input type="file" class="form-control @error('image') is-invalid @enderror" id="image" name="image">
                @error('image')
                    <span class="invalid-feedback">{{ $message }}</span>
                @enderror
                <img src="{{ asset('storage/' . $slider->image) }}" alt="Slider Image" style="max-width: 200px; margin-top: 10px;">
            </div>
            <div class="form-group">
                <label for="image_url">Image URL</label>
                <input type="url" class="form-control @error('image_url') is-invalid @enderror" id="image_url" name="image_url" value="{{ old('image_url', $slider->image_url) }}">
                @error('image_url')
                    <span class="invalid-feedback">{{ $message }}</span>
                @enderror
            </div>
            <button type="submit" class="btn btn-primary">Update Slider</button>
        </form>
    </div>
@endsection
