@extends('admin.admin_dashboard')
@section('admin')

<div class="page-content">
        <h1 class="h3 mb-4 text-gray-800">Add Slider</h1>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('sliders.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label for="image">Image</label>
                <input type="file" class="form-control @error('image_url') is-invalid @enderror" id="image_url" name="image_url" required>
                @error('image_url')
                    <span class="invalid-feedback">{{ $message }}</span>
                @enderror
            </div>
            <div class="form-group">
                <label for="image_url">Image URL</label>
                <input type="url" class="form-control @error('link') is-invalid @enderror" id="link" name="link">
                @error('link')
                    <span class="invalid-feedback">{{ $message }}</span>
                @enderror
            </div>
            <button type="submit" class="btn btn-primary">Add Slider</button>
        </form>
    </div>
@endsection
