@extends('admin.admin_dashboard')
@section('admin')

<div class="page-content">

        <!-- Page Heading -->
        <h1 class="h3 mb-4 text-gray-800">Site Settings</h1>

        <!-- Display Success and Error Messages -->
        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <!-- Settings Tabs -->
        <div class="card shadow mb-4">
            <div class="card-body">
                <!-- Nav tabs -->
                <ul class="nav nav-tabs" id="settingsTab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="support-info-tab" data-toggle="tab" href="#support-info" role="tab" aria-controls="support-info" aria-selected="true">Support Info</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="social-media-tab" data-toggle="tab" href="#social-media" role="tab" aria-controls="social-media" aria-selected="false">Social Media</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="logo-favicon-tab" data-toggle="tab" href="#logo-favicon" role="tab" aria-controls="logo-favicon" aria-selected="false">Logo & Favicon</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="payment-api-tab" data-toggle="tab" href="#payment-api" role="tab" aria-controls="payment-api" aria-selected="false">Payment API</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="seo-tab" data-toggle="tab" href="#seo" role="tab" aria-controls="seo" aria-selected="false">SEO Setup</a>
                    </li>
                </ul>

                <!-- Tab panes -->
                <div class="tab-content" id="settingsTabContent">
                    <!-- Support Information -->
                    <div class="tab-pane fade show active" id="support-info" role="tabpanel" aria-labelledby="support-info-tab">
                        <form action="{{ route('setting.update') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <h5 class="mt-3">Support Information</h5>
                            <div class="form-group">
                                <label for="support_phone">Support Phone</label>
                                <input type="text" class="form-control @error('support_phone') is-invalid @enderror" id="support_phone" name="support_phone" value="{{ old('support_phone', $settings['support_phone'] ?? '') }}" >
                                @error('support_phone')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="footer_email">Footer Email</label>
                                <input type="email" class="form-control @error('footer_email') is-invalid @enderror" id="footer_email" name="footer_email" value="{{ old('footer_email', $settings['footer_email'] ?? '') }}" >
                                @error('footer_email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="footer_copyright">Footer Copyright</label>
                                <input type="text" class="form-control @error('footer_copyright') is-invalid @enderror" id="footer_copyright" name="footer_copyright" value="{{ old('footer_copyright', $settings['footer_copyright'] ?? '') }}" >
                                @error('footer_copyright')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="notice_board">Notice Board</label>
                                <input type="text" class="form-control @error('notice_board') is-invalid @enderror" id="notice_board" name="notice_board" value="{{ old('notice_board', $settings['notice_board'] ?? '') }}" >
                                @error('notice_board')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-primary mt-3">Update Support Info</button>
                        </form>
                    </div>

                    <!-- Social Media Links -->
                    <div class="tab-pane fade" id="social-media" role="tabpanel" aria-labelledby="social-media-tab">
                        <form action="{{ route('setting.update') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <h5 class="mt-4">Social Media Links</h5>
                            <div class="form-group">
                                <label for="facebook_url">Facebook Link</label>
                                <input type="url" class="form-control @error('facebook_url') is-invalid @enderror" id="facebook_url" name="facebook_url" value="{{ old('facebook_url', $settings['facebook_url'] ?? 'data') }}" >
                                @error('facebook_url')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="messenger_url">Messenger Link</label>
                                <input type="url" class="form-control @error('messenger_url') is-invalid @enderror" id="messenger_url" name="messenger_url" value="{{ old('messenger_url', $settings['messenger_url'] ?? '') }}" >
                                @error('messenger_url')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="youtube_url">YouTube Link</label>
                                <input type="url" class="form-control @error('youtube_url') is-invalid @enderror" id="youtube_url" name="youtube_url" value="{{ old('youtube_url', $settings['youtube_url'] ?? '') }}" >
                                @error('youtube_url')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-primary mt-3">Update Social Media</button>
                        </form>
                    </div>

                    <!-- Logo and Favicon -->
                    <div class="tab-pane fade" id="logo-favicon" role="tabpanel" aria-labelledby="logo-favicon-tab">
                        <form action="{{ route('setting.update') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <h5 class="mt-4">Site Logo & Favicon</h5>
                            <div class="form-group">
                                <label for="logo">Site Logo</label>
                                <img src="{{ url('public/' . $settings['logo']) }}" alt="Site Logo" style="max-width: 200px;" class="mb-2">
                                <input type="file" class="form-control @error('logo') is-invalid @enderror" id="logo" name="logo">
                                @error('logo')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="favicon">Favicon</label>
                                <img src="{{ url('public/' . $settings['favicon']) }}" alt="Favicon" style="max-width: 50px;" class="mb-2">
                                <input type="file" class="form-control @error('favicon') is-invalid @enderror" id="favicon" name="favicon">
                                @error('favicon')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-primary mt-3">Update Logo & Favicon</button>
                        </form>
                    </div>

                    <!-- Payment API Settings -->
                    <div class="tab-pane fade" id="payment-api" role="tabpanel" aria-labelledby="payment-api-tab">
                        <form action="{{ route('setting.update') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <h5 class="mt-4">Payment API Settings</h5>
                            <div class="form-group">
                                <label for="api">API Key</label>
                                <input type="text" class="form-control @error('api') is-invalid @enderror" id="api" name="api" value="{{ old('api', $settings['api'] ?? '') }}" >
                                @error('api')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="client">Client ID</label>
                                <input type="text" class="form-control @error('client') is-invalid @enderror" id="client" name="client" value="{{ old('client', $settings['client'] ?? '') }}" >
                                @error('client')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="secret">Secret Key</label>
                                <input type="text" class="form-control @error('secret') is-invalid @enderror" id="secret" name="secret" value="{{ old('secret', $settings['secret'] ?? '') }}" >
                                @error('secret')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-primary mt-3">Update Payment API</button>
                        </form>
                    </div>

                    <!-- SEO Settings -->
                    <div class="tab-pane fade" id="seo" role="tabpanel" aria-labelledby="seo-tab">
                        <form action="{{ route('setting.update') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <h5 class="mt-4">SEO Settings</h5>
                            <div class="form-group">
                                <label for="site_title">Site Title</label>
                                <input type="text" class="form-control @error('site_title') is-invalid @enderror" id="site_title" name="site_title" value="{{ old('site_title', $settings['site_title'] ?? '') }}" >
                                @error('site_title')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="meta_keywords">Meta Keywords</label>
                                <input type="text" class="form-control @error('meta_keywords') is-invalid @enderror" id="meta_keywords" name="meta_keywords" value="{{ old('meta_keywords', $settings['meta_keywords'] ?? '') }}">
                                @error('meta_keywords')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="meta_description">Meta Description</label>
                                <textarea class="form-control @error('meta_description') is-invalid @enderror" id="meta_description" name="meta_description">{{ old('meta_description', $settings['meta_description'] ?? '') }}</textarea>
                                @error('meta_description')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="og_image">Open Graph Image</label>
                                <input type="file" class="form-control @error('og_image') is-invalid @enderror" id="og_image" name="og_image">
                                @error('og_image')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="twitter_image">Twitter Image</label>
                                <input type="file" class="form-control @error('twitter_image') is-invalid @enderror" id="twitter_image" name="twitter_image">
                                @error('twitter_image')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-primary mt-3">Update SEO</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="{{ url('/') }}/public/assets/backend/vendor/jquery/jquery.min.js"></script>
    <script src="{{ url('/') }}/public/assets/backend/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <script src="{{ url('/') }}/public/assets/backend/js/sb-admin-2.min.js"></script>
@endsection
