@extends('admin.admin_dashboard')
@section('admin')

<div class="page-content">
    <h1 class="h3 mb-4 text-gray-800">Menu List</h1>

    <!-- Success Message -->
    @if (session()->has('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <!-- Create Menu Button -->
    <div class="mb-3">
        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#createMenuModal">
            Create New Menu
        </button>
    </div>

    <!-- Create Menu Modal -->
    <div class="modal fade" id="createMenuModal" tabindex="-1" aria-labelledby="createMenuModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="createMenuForm" action="{{ route('menus.store') }}" method="POST">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title" id="createMenuModalLabel">Create New Menu</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="new_menu_name">Menu Name</label>
                            <input type="text" class="form-control" id="new_menu_name" name="name" required>
                        </div>
                        <div class="form-group">
                            <label for="new_menu_link">Menu Link</label>
                            <input type="text" class="form-control" id="new_menu_link" name="link" required>
                        </div>
                        <div class="form-group">
                            <label for="new_menu_icon">Menu Icon</label>
                            <input type="text" class="form-control" id="new_menu_icon" name="icon" required>
                        </div>
                        <div class="form-group">
                            <label for="new_menu_status">Status</label>
                            <select class="form-control" id="new_menu_status" name="status" required>
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Create Menu</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Menu Table -->
    <div class="card shadow mb-4">
        <div class="card-body">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Link</th>
                        <th>Icon</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($menus as $menu)
                        <tr>
                            <td>{{ $menu->id }}</td>
                            <td>{{ $menu->name }}</td>
                            <td><a href="{{ $menu->link }}" target="_blank">{{ $menu->link }}</a></td>
                            <td>{!! $menu->icon !!}</td>
                            <td>{{ $menu->status ? 'Active' : 'Inactive' }}</td>
                            <td>
                                <button type="button" class="btn btn-sm btn-primary" 
                                        data-bs-toggle="modal" 
                                        data-bs-target="#editMenuModal" 
                                        onclick="openEditMenuModal({{ json_encode($menu) }})">
                                    Edit
                                </button>
                                <button type="button" class="btn btn-sm btn-danger" 
                                        data-bs-toggle="modal" 
                                        data-bs-target="#deleteMenuModal" 
                                        onclick="setDeleteMenu({{ $menu->id }})">
                                    Delete
                                </button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Edit Menu Modal -->
<div class="modal fade" id="editMenuModal" tabindex="-1" aria-labelledby="editMenuModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="editMenuForm" action="" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="editMenuModalLabel">Edit Menu</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="menu_name">Menu Name</label>
                        <input type="text" class="form-control" id="menu_name" name="name" required>
                    </div>
                    <div class="form-group">
                        <label for="menu_link">Menu Link</label>
                        <input type="text" class="form-control" id="menu_link" name="link" required>
                    </div>
                    <div class="form-group">
                        <label for="menu_icon">Menu Icon</label>
                        <input type="text" class="form-control" id="menu_icon" name="icon" required>
                    </div>
                    <div class="form-group">
                        <label for="menu_status">Status</label>
                        <select class="form-control" id="menu_status" name="status" required>
                            <option value="1">Active</option>
                            <option value="0">Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Menu Modal -->
<div class="modal fade" id="deleteMenuModal" tabindex="-1" aria-labelledby="deleteMenuModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="deleteMenuForm" action="" method="POST">
                @csrf
                @method('DELETE')
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteMenuModalLabel">Delete Menu</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete this menu?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Delete</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
   function openEditMenuModal(menu) {
       document.getElementById('menu_name').value = menu.name;
       document.getElementById('menu_link').value = menu.link;
       document.getElementById('menu_icon').value = menu.icon;
       document.getElementById('menu_status').value = menu.status;

       // Set the form action to include the menu ID
       document.getElementById('editMenuForm').action = `{{ url('/admin/menus') }}/${menu.id}/update`;

       // Show the modal
       var myModal = new bootstrap.Modal(document.getElementById('editMenuModal'));
       myModal.show();
   }

   function setDeleteMenu(menuId) {
       // Set the form action to include the menu ID for deletion
       document.getElementById('deleteMenuForm').action = `{{ url('/admin/menus') }}/${menuId}`;
   }
</script>

@endsection
