@extends('admin.admin_dashboard') 
@section('admin')

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@simonwep/pickr/dist/themes/classic.min.css" />

<style>
    .pcr-button {
        width: 40px;
        height: 40px;
        border-radius: 5px;
        margin-right: 5px;
    }
    
    .color-preview {
        width: 40px;
        height: 40px;
        border-radius: 5px;
        display: inline-block;
        margin-right: 10px;
        border: 1px solid #ddd;
    }

    .color-section {
        background: #f8f9fa;
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 15px;
    }

    .color-label {
        font-weight: 500;
        color: #333;
        min-width: 200px;
    }

    .notification {
        position: fixed;
        top: 20px;
        right: 20px;
        padding: 15px 25px;
        border-radius: 4px;
        z-index: 1000;
        display: none;
    }

    .success-notification {
        background: #28a745;
        color: white;
    }
</style>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="card-title">Color Settings</h4>
            </div>
            <div class="card-body">
                @if(session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif

                <form action="{{ route('color.setting.update') }}" method="POST" id="colorSettingsForm">
                    @csrf
                    <div class="color-section">
                        @php
                            $colorFields = [
                                'theme_color' => 'Theme Color',
                                'logo_color' => 'Logo Color',
                                'primary_font_color' => 'Primary Font Color',
                                'navigation_background_color' => 'Navigation Background Color',
                                'navigation_font_color' => 'Navigation Font Color',
                                'footer_color' => 'Footer Background Color',
                                'footer_font_color' => 'Footer Font Color',
                                'content_box_color' => 'Content Box Color',
                                'notice_font_color' => 'Notice Font Color',
                                'notice_background_color' => 'Notice Background Color',
                                'footer_info' => 'Footer Info Color',
                                'content_heading_color' => 'Content Heading Color',
                                'support_link_hover_color' => 'Support Link Hover Color',
                                'nav_link_color' => 'Nav Link Color',
                                'nav_link_hover_color' => 'Nav Link Hover Color',
                                'social_media_color' => 'Social Media Icon Color',
                                'footer_rights_color' => 'Footer Rights Color'
                            ];
                        @endphp

                        @foreach($colorFields as $field => $label)
                            <div class="mb-4">
                                <div class="d-flex align-items-center">
                                    <label class="color-label">{{ $label }}</label>
                                    <div class="d-flex align-items-center">
                                        <div class="color-preview" 
                                             style="background-color: {{ $Colorsettings[$field] ?? '#ffffff' }}">
                                        </div>
                                        <input type="hidden" 
                                               name="{{ $field }}" 
                                               id="{{ $field }}_input" 
                                               value="{{ $Colorsettings[$field] ?? '#ffffff' }}">
                                        <div class="pickr-container" id="pickr_{{ $field }}"></div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    
                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div id="successNotification" class="notification success-notification">
    Settings saved successfully!
</div>

<script src="https://cdn.jsdelivr.net/npm/@simonwep/pickr/dist/pickr.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const colorFields = @json($colorFields);
    
    // Initialize color pickers
    Object.keys(colorFields).forEach(field => {
        const pickrContainer = document.querySelector(`#pickr_${field}`);
        const colorInput = document.querySelector(`#${field}_input`);
        const colorPreview = pickrContainer.previousElementSibling;
        
        const pickr = Pickr.create({
            el: pickrContainer,
            theme: 'classic',
            default: colorInput.value,
            swatches: [
                '#000000', '#ffffff', '#ff5733', '#33ff57', 
                '#3357ff', '#f0ad4e', '#5bc0de', '#d9534f'
            ],
            components: {
                preview: true,
                opacity: true,
                hue: true,
                interaction: {
                    hex: true,
                    rgba: true,
                    hsla: false,
                    hsva: false,
                    cmyk: false,
                    input: true,
                    clear: true,
                    save: true
                }
            }
        });

        // Update on color change
        pickr.on('change', (color) => {
            const hexColor = color.toHEXA().toString();
            colorInput.value = hexColor;
            colorPreview.style.backgroundColor = hexColor;
        });

        // Save color when save button is clicked
        pickr.on('save', (color) => {
            if (color) {
                const hexColor = color.toHEXA().toString();
                colorInput.value = hexColor;
                colorPreview.style.backgroundColor = hexColor;
            }
            pickr.hide();
        });
    });

    // Show notification function
    function showNotification(message, type = 'success') {
        const notification = document.getElementById('successNotification');
        notification.textContent = message;
        notification.style.display = 'block';
        
        setTimeout(() => {
            notification.style.display = 'none';
        }, 3000);
    }

    // Handle form submission
    document.getElementById('colorSettingsForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        fetch(this.action, {
            method: 'POST',
            body: new FormData(this),
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => {
            if (response.redirected) {
                window.location.href = response.url;
            } else {
                showNotification('Colors saved successfully!');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showNotification('Error saving colors. Please try again.', 'error');
        });
    });
});
</script>

@endsection
