@extends('admin.admin_dashboard')

@section('admin')
    <div class="page-content">
        <h1 class="h3 mb-2 text-gray-800">Processing Order <span
                class="badge bg-danger rounded-pill modern-badge">{{ count(value: $paidOrders) }}</h1>

        <!-- Alert Messages -->
        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session('success') }}
            </div>
        @endif
        @if (session()->has('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif



        <!-- Orders Table -->
        <div class="table-responsive">
            <table id="dataTableExample" class="table table-striped table-bordered" style="width:100%">
                <thead>
                    <tr class="align-middle">
                        <th>ID</th>
                        <th>Name</th>
                        <th>Date</th>
                        <th>Package</th>
                        <th>Price</th>
                        <th>Payment Gateway</th>
                        <th>Payment</th>
                        <th>Order Status</th>
                        <th>UID/Voucher</th>
                        <th>Action</th>
                    </tr>
                </thead>
                @foreach ($paidOrders as $order)
                    <tbody>
                        <tr>
                            <td>{{ $order->id }}</td>
                            <td>{{ $order->user->name }}</td>
                            <td>{{ $order->created_at->format('j M y, h:i A') }}</td>
                            <td>{{ Str::limit(optional($order->variation)->title, 19) }}</td>
                            <td>৳{{ number_format($order->total_price, 2) }}</td>
                            <td>
                                <button class="btn btn-success btn-sm">{{ $order->payment_type }}</button>
                            </td>
                            <td>
                                <button class="btn btn-{{ (int) $order->status === 0 ? 'danger' : 'success' }} btn-sm">
                                    {{ (int) $order->status === 0 ? 'Pending Payment' : 'Paid' }}
                                </button>
                            </td>
                            <td>
                                @if ($order->auto_status == 1)
                                    <button class="btn btn-primary btn-sm">Auto Processing</button>
                                @elseif ($order->auto_status == 2)
                                    <button class="btn btn-success btn-sm">Complete</button>
                                @elseif ($order->auto_status == 3)
                                    <button class="btn btn-danger btn-sm">Cancelled</button>
                                @else
                                    @if ($order->status == 1)
                                        <button class="btn btn-info btn-sm">Processing</button>
                                    @elseif ($order->status == 2)
                                        <button class="btn btn-success btn-sm">Complete</button>
                                    @elseif ($order->status == 3)
                                        <button class="btn btn-danger btn-sm">Cancelled</button>
                                    @else
                                        <button class="btn btn-danger btn-sm">Pending</button>
                                    @endif
                                @endif
                            </td>
                            <td>
                                @if ($order->type === 'voucher' && $order->voucher)
                                    {{ $order->voucher->code }} {{-- Show voucher code --}}
                               @elseif (!empty($order->player_id))
    
    <button onclick="copyToClipboard('{{ $order->player_id }}')" class="btn btn-danger">    {{ Str::limit($order->player_id, 10) }} <div>Click To Copy </div></button>
    <script>
    function copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(() => {
            alert('Player ID copied: ' + text);
        }).catch(err => {
            console.error('Failed to copy:', err);
        });
    }
</script>
@else
                                @endif
                                 @if ($order->type === 'ingame')
                                <button class="btn btn-sm btn-warning mt-2" onclick="showPopup('ingame-popup-{{ $order->id }}')">In-Game Details</button>

                                <div id="ingame-popup-{{ $order->id }}" class="popup" style="display: none;">
                                    <div class="popup-content">
                                        <span class="close-btn" onclick="closePopup('ingame-popup-{{ $order->id }}')">&times;</span>
                                        <h4>In-Game Details</h4>
                                        <div class="detail-item">
                                            <strong>Account Type: </strong> {{ $order->game_account_type }}
                                            
                                        </div>
                                        <div class="detail-item">
                                            <strong>Account:</strong> {{ $order->game_account }}
                                            <button onclick="copyText('{{ $order->game_account }}')" class="btn btn-sm btn-info">Copy</button>
                                        </div>
                                        <div class="detail-item">
                                            <strong>Password:</strong> {{ $order->game_password }}
                                            <button onclick="copyText('{{ $order->game_password }}')" class="btn btn-sm btn-info">Copy</button>
                                        </div>
                                        <div class="detail-item">
                                            <strong>Backup Code:</strong> {{ $order->game_backup }}
                                            <button onclick="copyText('{{ $order->game_backup }}')" class="btn btn-sm btn-info">Copy</button>
                                        </div>
                                    </div>
                                </div>

                                <script>
                                    function showPopup(popupId) {
                                        document.getElementById(popupId).style.display = 'flex';
                                    }
                                    function closePopup(popupId) {
                                        document.getElementById(popupId).style.display = 'none';
                                    }
                                    function copyText(text) {
                                        navigator.clipboard.writeText(text).then(() => {
                                            alert('Copied: ' + text);
                                        }).catch(err => {
                                            console.error('Failed to copy:', err);
                                        });
                                    }
                                </script>

                                <style>
                                    .popup {
                                        position: fixed;
                                        top: 0;
                                        left: 0;
                                        width: 100%;
                                        height: 100%;
                                        background: rgba(0, 0, 0, 0.5);
                                        display: flex;
                                        justify-content: center;
                                        align-items: center;
                                        z-index: 1000;
                                    }
                                    .popup-content {
                                        background: #ffc107;
                                        color: black;
                                        padding: 20px;
                                        border-radius: 10px;
                                        text-align: left;
                                        position: relative;
                                        width: auto;
                                        max-width: 400px;
                                    }
                                    .detail-item {
                                        background: white;
                                        padding: 10px;
                                        border-radius: 5px;
                                        margin: 5px 0;
                                        display: flex;
                                        justify-content: space-between;
                                        align-items: center;
                                    }
                                </style>
                                 <style>
                                                .voucher-popup {
                                                    position: fixed;
                                                    top: 0;
                                                    left: 0;
                                                    width: 100%;
                                                    height: 100%;
                                                    background: rgba(0, 0, 0, 0.5);
                                                    display: flex;
                                                    justify-content: center;
                                                    align-items: center;
                                                    z-index: 1000;
                                                }
                                                .voucher-popup-content {
                                                    background: #007bff;
                                                    color: white;
                                                    padding: 20px;
                                                    border-radius: 10px;
                                                    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
                                                    text-align: center;
                                                    position: relative;
                                                    width: auto;
                                                }
                                                .close-btn {
                                                    position: absolute;
                                                    right: 10px;
                                                    top: 10px;
                                                    cursor: pointer;
                                                    font-size: 24px;
                                                    color: white;
                                                }
                                                .voucher-item {
                                                    background: white;
                                                    color: black;
                                                    padding: 10px;
                                                    border-radius: 5px;
                                                    margin: 5px 0;
                                                }
                                                .btn-success {
                                                    background-color: #28a745;
                                                    border-color: #28a745;
                                                }
                                            </style>
                                @endif
                            
                            </td>
                            <td>
                                <a href="{{ route('admin.order.edit', $order->id) }}" class="btn btn-success btn-sm">
                                    <i class="fas fa-pen"></i>
                                </a>

                                <a href="{{ route('paid.order.delete', $order->id) }}" class="btn btn-danger btn-sm"
                                    id="delete">
                                    <i class="fas fa-trash"></i>
                                </a>


                                @if ($order->autoTopup)
                                    <a href="https://api.hidetopup.com/transactions/{{ $order->autoTopup->uid }}"
                                        target="_blank" class="btn btn-primary btn-sm">
                                        API
                                    </a>
                                @else
                                    <span class="text-muted">No API</span>
                                @endif

                        

                        </tr>
                    </tbody>
                @endforeach
            </table>
        </div>

        {{-- <!-- Pagination -->
    <div class="mt-3">
        {{ $paidOrders->links() }}
    </div> --}}
    </div>
@endsection
