@extends('admin.admin_dashboard')

@section('admin')
<div class="page-content">
    <h1 class="h3 mb-2 text-gray-800">Pending Order <span class="badge bg-danger rounded-pill modern-badge">{{ count(value: $orders) }}</span></h1>

    <!-- Alert Messages -->
    @if (session()->has('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif
    @if (session()->has('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif


    
    <!-- Orders Table -->
      <div class="table-responsive">
            <table id="dataTableExample" class="table table-striped table-bordered" style="width:100%">
                <thead>
                    <tr class="align-middle">
                        <th>ID</th>
                        <th>Name</th>
                        <th>Date</th>
                        <th>Package</th>
                        <th>Price</th>
                        <th>Payment Gateway</th>
                        <th>Payment</th>
                        <th>Order Status</th>
                        <th>UID/Voucher</th>
                        <th>Action</th>
                    </tr>
                </thead>
                @foreach ($orders as $order)
                <tbody>
                    <tr>
                        <td>{{ $order->id }}</td>
                        <td>{{ $order->user->name }}</td>
                        <td>{{ $order->created_at->format('j M y, h:i A') }}</td>
                        <td>{{ Str::limit(optional($order->variation)->title, 19) }}</td>
                        <td>৳{{ number_format($order->total_price, 2) }}</td>
                        <td>
                            <button class="btn btn-success btn-sm">{{ $order->payment_type }}</button>
                        </td>
                        <td>
                            <button class="btn btn-{{ (int)$order->status === 0 ? 'danger' : 'success' }} btn-sm">
                                {{ (int)$order->status === 0 ? 'Pending Payment' : 'Paid' }}
                            </button>
                        </td>
                        <td>
                            @if ($order->auto_status == 0)
                            <button class="btn btn-warning btn-sm">Pending</button>
                            @elseif ($order->status == 0)
                            <button class="btn btn-warning btn-sm">Pending</button>
                            @endif
                        </td>
                        <td>
                            {{ $order->type === 'voucher' && $order->voucher ? $order->voucher->code : $order->player_id }}
                        </td>
                        <td>
                            <a href="{{ route('admin.order.edit', $order->id) }}" class="btn btn-success btn-sm">
                                <i class="fas fa-pen"></i>
                            </a>

                            <a href="{{ route('paid.order.delete', $order->id) }}" class="btn btn-danger btn-sm" id="delete">
                                <i class="fas fa-trash"></i>
                            </a>



                        </td>
                        @if ($order->type === 'ingame')
                        <td>
                                <!-- Popover Button -->
                                <button type="button" 
                                        class="btn btn-info btn-sm" 
                                        data-bs-toggle="popover" 
                                        data-bs-trigger="focus" 
                                        data-bs-content="
                                            Account Type: {{ $order->game_account_type }}
                                           Account: {{ $order->game_account }}
                                            Password:{{ $order->game_password }}
                                          Backup Code:{{ $order->game_backup }}">
                                    Details
                                </button>
                        </td>
                        @endif
                    </tr>
                </tbody>       
                @endforeach
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-3">
        {{ $orders->links() }}
    </div>
</div>
@endsection