@extends('admin.admin_dashboard')

@section('admin')
<div class="page-content">
    <h1 class="h3 mb-2 text-gray-800">Complete   Order List</h1>

    <!-- Alert Messages -->
    @if (session()->has('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif
    @if (session()->has('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif


    
    <!-- Orders Table -->
      <div class="table-responsive">
            <table id="dataTableExample" class="table table-striped table-bordered" style="width:100%">
                <thead>
                    <tr class="align-middle">
                        <th class="pt-0">ID</th>
                        <th class="pt-0">Name</th>
                        <th class="pt-0">Date</th>
                        <th class="pt-0">Package</th>
                        <th class="pt-0">Quantity</th>
                        <th class="pt-0">Price</th>
                        <th class="pt-0">Payment Gateway</th>
                        <th class="pt-0">Payment</th>
                        <th class="pt-0">Order Status</th>
                        <th class="pt-0">UID/Voucher</th>
                        <th class="pt-0">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($paidOrders as $order)
                        <tr>
                            <td>{{ $order->id }}</td>
                            <td>{{ $order->user->name }}</td>
                            <td>{{ $order->created_at->format('j M y, h:i A') }}</td>
                            <td>{{ Str::limit(optional($order->variation)->title, 19) }}</td>
                            <td>{{ $order->qty }}</td>
                            <td>৳{{ number_format($order->total_price, 2) }}</td>
                            <td>
                                <button class="btn btn-success btn-sm">{{ $order->payment_type }}</button>
                            </td>
                            <td>
                                <button class="btn btn-{{ (int) $order->status === 0 ? 'danger' : 'success' }} btn-sm">
                                    {{ (int) $order->status === 0 ? 'Pending Payment' : 'Paid' }}
                                </button>
                            </td>
                            <td>
                                @if ($order->auto_status == 2 || $order->status == 2)
                                    <button class="btn btn-success btn-sm">Complete</button>
                                @endif
                            </td>
                            <td>
                                @if ($order->type === 'voucher')
                                    @if ($order->items && $order->items->isNotEmpty())
                                        @php
                                            $voucherCodes = $order->items
                                                ->map(function ($item) {
                                                    return $item->voucher ? $item->voucher->code : null;
                                                })
                                                ->filter()
                                                ->implode(', ');
                                        @endphp
                                        @if ($voucherCodes)
                                            <button class="btn btn-sm btn-primary mt-2" onclick="showVoucherPopup({{ $order->id }})">Show Vouchers</button>

                                            <div id="voucher-popup-{{ $order->id }}" class="voucher-popup" style="display: none;">
                                                <div class="voucher-popup-content">
                                                    <span class="close-btn" onclick="closeVoucherPopup({{ $order->id }})">&times;</span>
                                                    <h4>Vouchers</h4>
                                                    <div id="voucher-list-{{ $order->id }}">
                                                        @foreach ($order->items as $item)
                                                            @if ($item->voucher)
                                                                <div class="voucher-item">{{ $item->voucher->code }}</div>
                                                            @endif
                                                        @endforeach
                                                    </div>
                                                    <button class="btn btn-sm btn-success mt-3" onclick="copyAllVouchers({{ $order->id }})">Copy All Vouchers</button>
                                                </div>
                                            </div>

                                            <script>
                                                function showVoucherPopup(orderId) {
                                                    document.getElementById('voucher-popup-' + orderId).style.display = 'flex';
                                                }

                                                function closeVoucherPopup(orderId) {
                                                    document.getElementById('voucher-popup-' + orderId).style.display = 'none';
                                                }

                                                function copyAllVouchers(orderId) {
                                                    var voucherList = document.getElementById('voucher-list-' + orderId).innerText;
                                                    navigator.clipboard.writeText(voucherList).then(() => {
                                                        alert('All vouchers copied!');
                                                    }).catch(err => {
                                                        console.error('Failed to copy all:', error);
                                                    });
                                                }
                                            </script>

                                            <style>
                                                .voucher-popup {
                                                    position: fixed;
                                                    top: 0;
                                                    left: 0;
                                                    width: 100%;
                                                    height: 100%;
                                                    background: rgba(0, 0, 0, 0.5);
                                                    display: flex;
                                                    justify-content: center;
                                                    align-items: center;
                                                    z-index: 1000;
                                                }
                                                .voucher-popup-content {
                                                    background: #007bff;
                                                    color: white;
                                                    padding: 20px;
                                                    border-radius: 10px;
                                                    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
                                                    text-align: center;
                                                    position: relative;
                                                    width: auto;
                                                }
                                                .close-btn {
                                                    position: absolute;
                                                    right: 10px;
                                                    top: 10px;
                                                    cursor: pointer;
                                                    font-size: 24px;
                                                    color: white;
                                                }
                                                .voucher-item {
                                                    background: white;
                                                    color: black;
                                                    padding: 10px;
                                                    border-radius: 5px;
                                                    margin: 5px 0;
                                                }
                                                .btn-success {
                                                    background-color: #28a745;
                                                    border-color: #28a745;
                                                }
                                            </style>
                                        @else
                                            <span class="text-warning">No Voucher Assigned</span>
                                        @endif
                                    @else
                                        <span class="text-warning">{{ $order->voucher->code ?? 'No vouchers available' }}</span>
                                    @endif
                                @elseif (!empty($order->player_id))
    
    <button onclick="copyToClipboard('{{ $order->player_id }}')" class="btn btn-danger">    {{ Str::limit($order->player_id, 10) }} <div>Click To Copy </div></button>
    <script>
    function copyToClipboard(text) {
        navigator.clipboard.writeText(text).then(() => {
            alert('Player ID copied: ' + text);
        }).catch(err => {
            console.error('Failed to copy:', err);
        });
    }
</script>
@else
                                @endif
                                 @if ($order->type === 'ingame')
                                <button class="btn btn-sm btn-warning mt-2" onclick="showPopup('ingame-popup-{{ $order->id }}')">In-Game Details</button>

                                <div id="ingame-popup-{{ $order->id }}" class="popup" style="display: none;">
                                    <div class="popup-content">
                                        <span class="close-btn" onclick="closePopup('ingame-popup-{{ $order->id }}')">&times;</span>
                                        <h4>In-Game Details</h4>
                                        <div class="detail-item">
                                            <strong>Account Type:</strong> {{ $order->game_account_type }}
                                            <button onclick="copyText('{{ $order->game_account_type }}')" class="btn btn-sm btn-info">Copy</button>
                                        </div>
                                        <div class="detail-item">
                                            <strong>Account:</strong> {{ $order->game_account }}
                                            <button onclick="copyText('{{ $order->game_account }}')" class="btn btn-sm btn-info">Copy</button>
                                        </div>
                                        <div class="detail-item">
                                            <strong>Password:</strong> {{ $order->game_password }}
                                            <button onclick="copyText('{{ $order->game_password }}')" class="btn btn-sm btn-info">Copy</button>
                                        </div>
                                        <div class="detail-item">
                                            <strong>Backup Code:</strong> {{ $order->game_backup }}
                                            <button onclick="copyText('{{ $order->game_backup }}')" class="btn btn-sm btn-info">Copy</button>
                                        </div>
                                    </div>
                                </div>

                                <script>
                                    function showPopup(popupId) {
                                        document.getElementById(popupId).style.display = 'flex';
                                    }
                                    function closePopup(popupId) {
                                        document.getElementById(popupId).style.display = 'none';
                                    }
                                    function copyText(text) {
                                        navigator.clipboard.writeText(text).then(() => {
                                            alert('Copied: ' + text);
                                        }).catch(err => {
                                            console.error('Failed to copy:', err);
                                        });
                                    }
                                </script>

                                <style>
                                    .popup {
                                        position: fixed;
                                        top: 0;
                                        left: 0;
                                        width: 100%;
                                        height: 100%;
                                        background: rgba(0, 0, 0, 0.5);
                                        display: flex;
                                        justify-content: center;
                                        align-items: center;
                                        z-index: 1000;
                                    }
                                    .popup-content {
                                        background: #ffc107;
                                        color: black;
                                        padding: 20px;
                                        border-radius: 10px;
                                        text-align: left;
                                        position: relative;
                                        width: auto;
                                        max-width: 400px;
                                    }
                                    .detail-item {
                                        background: white;
                                        padding: 10px;
                                        border-radius: 5px;
                                        margin: 5px 0;
                                        display: flex;
                                        justify-content: space-between;
                                        align-items: center;
                                    }
                                </style>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('admin.order.edit', $order->id) }}" class="btn btn-success btn-sm">
                                    <i class="fas fa-pen"></i>
                                </a>
                                <a href="{{ route('paid.order.delete', $order->id) }}" class="btn btn-danger btn-sm"
                                    id="delete">
                                    <i class="fas fa-trash"></i>
                                </a>
                                @if ($order->autoTopup)
                                    <a href="https://api.hidetopup.com/transactions/{{ $order->autoTopup->uid }}"
                                        target="_blank" class="btn btn-primary btn-sm">
                                        Check API
                                    </a>
                                @else
                                    <span class="text-muted">No API Data</span>
                                @endif
                            
                        
                    </tr>
                </tbody>       
                @endforeach
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-3">
        {{ $paidOrders->links() }}
    </div>
</div>




@endsection