<!DOCTYPE html>

<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
  <meta name="description" content="Responsive HTML Admin Dashboard Template based on Bootstrap 5">
	<meta name="author" content="NobleUI">
	<meta name="keywords" content="nobleui, bootstrap, bootstrap 5, bootstrap5, admin, dashboard, template, responsive, css, sass, html, theme, front-end, ui kit, web">

	<title>Admin Dashboard </title>

  <!-- Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700;900&display=swap" rel="stylesheet">
  <!-- End fonts -->

	<!-- core:css -->

    <link rel="stylesheet" href="{{ url('/') }}/public/assets/vendors/corecore.css">


	<!-- endinject -->

	<!-- Plugin css for this page -->
	<!-- End plugin css for this page -->

	<!-- inject:css -->
    <link rel="stylesheet" href="{{ url('/') }}/public/assets/backend/fonts/feather-font/css/iconfont.css">

    <link rel="stylesheet" href="{{ url('/') }}/public/assets/backend/vendors/flag-icon-css/css/flag-icon.min.css">
	<!-- endinject -->

  <!-- Layout styles -->  
  <link rel="stylesheet" href="{{ url('/') }}/public/assets/backend/css/demo2/style.css">

  <!-- End layout styles -->
  <link rel="stylesheet" href="{{ url('/') }}/public/assets/images/favicon.png">


</head>
<body>
	<div class="main-wrapper">
		<div class="page-wrapper full-page">
			<div class="page-content d-flex align-items-center justify-content-center">

				<div class="row w-100 mx-0 auth-page">
					<div class="col-md-8 col-xl-6 mx-auto">
						<div class="card">
							<div class="row">
                
                <div class="col-md-8 ps-md-0">
                  <div class="auth-form-wrapper px-4 py-5">
                    <a href="#" class="noble-ui-logo logo-light d-block mb-2">Game<span>Shop</span></a>
                    <h5 class="text-muted fw-normal mb-4">Welcome back! Log in to your account.</h5>
                    <form method="POST" action="{{ url('login') }}">
                        @csrf
                      <div class="mb-3">
                        <label for="userEmail" class="form-label">Email address</label>
                        <input type="text" class="form-control" name="email" placeholder="Email" value="{{ old('email') }}">
                      </div>
                      @error('email')
                      <span class="text-danger">{{ $message }}</span>
                  @enderror
                      <div class="mb-3">
                        <label for="userPassword" class="form-label">Password</label>
                        <input type="password" class="form-control" name="password" placeholder="Password" autocomplete="off">
                      </div>
                      @error('password')
                      <span class="text-danger">{{ $message }}</span>
                  @enderror

                <div class="component_button_submit">
                        <div class="form-group">
                            <div class>
                                <button type="submit" name="signin"
                                class="btn btn-light theme-btn-block">LOGIN</button>
                            </div>
                        </div>
                    </div>
                    
                    
                    </form>
                  </div>

                  
                </div>
              </div>
						</div>
					</div>
				</div>

			</div>
		</div>
	</div>

	<!-- core:js -->
    <script src="{{ url('/') }}/public/assets/backend/vendors/core/core.js"></script>
	<!-- endinject -->

	<!-- Plugin js for this page -->
	<!-- End plugin js for this page -->

	<!-- inject:js -->
    <script src="{{ url('/') }}/public/assets/backend/vendors/feather-icons/feather.min.js"></script>

    <script src="{{ url('/') }}/public/assets/backend/js/template.js"></script>

	<!-- endinject -->

	<!-- Custom js for this page -->
	<!-- End custom js for this page -->

</body>
</html>