<nav class="sidebar">
    <div class="sidebar-header">
        <a href="#" class="sidebar-brand">
            Game<span>Shop</span>
        </a>
        <div class="sidebar-toggler not-active">
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <div class="sidebar-body">
        <ul class="nav">
            <!-- Dashboard -->
            <li class="nav-item">
                <a href="{{ route('admin.dashboard') }}" class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                    <i class="link-icon" data-feather="box"></i>
                    <span class="link-title">Dashboard</span>
                </a>
            </li>

            <li class="nav-item">
                <a href="{{ route('user.leaderboard') }}" class="nav-link {{ request()->routeIs('user.leaderboard') ? 'active' : '' }}">
                    <i class="fas fa-trophy"></i>
                    <span class="link-title">Leaderboard</span>
                </a>
            </li>



            

            <!-- User Management -->
            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="collapse" href="#userManagement" role="button"
                   aria-expanded="{{ request()->routeIs('admin.users.*') ? 'true' : 'false' }}"
                   aria-controls="userManagement">
                    <i class="link-icon" data-feather="users"></i>
                    <span class="link-title">User Management</span>
                    <i class="link-arrow" data-feather="chevron-down"></i>
                </a>
                <div class="collapse {{ request()->routeIs('admin.users.*') ? 'show' : '' }}" id="userManagement">
                    <ul class="nav sub-menu">
                        <li class="nav-item">
                            <a href="{{ url('admin/users') }}" class="nav-link {{ request()->routeIs('admin.users.*') ? 'active' : '' }}">
                                Manage Users
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

     
<!-- Order Management -->
<li class="nav-item">
    <a class="nav-link" data-bs-toggle="collapse" href="#orderManagement" role="button"
       aria-expanded="{{ request()->routeIs('paid.order') || request()->routeIs('admin.order.index') ? 'true' : 'false' }}"
       aria-controls="orderManagement">
        <i class="link-icon" data-feather="shopping-bag"></i>
        <span class="link-title">Order Management</span>
        <i class="link-arrow" data-feather="chevron-down"></i>
    </a>
    <div class="collapse {{ request()->routeIs('admin.paid.order') || request()->routeIs('admin.order.index') ? 'show' : '' }}" id="orderManagement">
        <ul class="nav sub-menu">
            @auth
             
                    <li class="nav-item">
                        <a href="{{ route('admin.paid.order') }}" class="nav-link {{ request()->routeIs('admin.paid.order') ? 'active' : '' }}">
                            Complete Orders
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('admin.prossesing.order') }}" class="nav-link {{ request()->routeIs('admin.prossesing .order') ? 'active' : '' }}">
                            Processing Orders
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('admin.pending.order') }}" class="nav-link {{ request()->routeIs('admin.order.index') ? 'active' : '' }}">
                            Pending Orders
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('admin.order.index') }}" class="nav-link {{ request()->routeIs('admin.order.index') ? 'active' : '' }}">
                            Cancelled Orders
                        </a>
                    </li>

                    
                
            @endauth
        </ul>
    </div>
</li>


            <!-- Product Management -->
            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="collapse" href="#productManagement" role="button"
                   aria-expanded="{{ request()->routeIs('admin.product.*') || request()->routeIs('admin.variation.*') ? 'true' : 'false' }}"
                   aria-controls="productManagement">
                    <i class="link-icon" data-feather="package"></i>
                    <span class="link-title">Product Management</span>
                    <i class="link-arrow" data-feather="chevron-down"></i>
                </a>
                <div class="collapse {{ request()->routeIs('admin.product.*') || request()->routeIs('admin.variation.*') ? 'show' : '' }}" id="productManagement">
                    <ul class="nav sub-menu">
                        <li class="nav-item">
                            <a href="{{ route('admin.product.index') }}" class="nav-link {{ request()->routeIs('admin.product.index') ? 'active' : '' }}">
                                All Products
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.product.create') }}" class="nav-link {{ request()->routeIs('admin.product.create') ? 'active' : '' }}">
                                Add Product
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('admin/variation/list') }}" class="nav-link {{ request()->routeIs('admin.variation.list') ? 'active' : '' }}">
                                Product Variations
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <!-- Voucher Management -->
            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="collapse" href="#voucherManagement" role="button"
                   aria-expanded="{{ request()->routeIs('admin.voucher.*') ? 'true' : 'false' }}"
                   aria-controls="voucherManagement">
                    <i class="link-icon" data-feather="gift"></i>
                    <span class="link-title">Voucher Management</span>
                    <i class="link-arrow" data-feather="chevron-down"></i>
                </a>
                <div class="collapse {{ request()->routeIs('admin.voucher.*') ? 'show' : '' }}" id="voucherManagement">
                    <ul class="nav sub-menu">
                        <li class="nav-item">
                            <a href="{{ route('admin.voucher.index') }}" class="nav-link {{ request()->routeIs('admin.voucher.index') ? 'active' : '' }}">
                                All Vouchers
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.voucher.create') }}" class="nav-link {{ request()->routeIs('admin.voucher.create') ? 'active' : '' }}">
                                Add Voucher
                            </a>
                        </li>
                            <!-- New Link for Available Vouchers -->
            <li class="nav-item">
                <a href="{{ route('available') }}" class="nav-link {{ request()->routeIs('available') ? 'active' : '' }}">
                    Available Vouchers
                </a>
            </li>
                    </ul>
                </div>
            </li>

            <!-- Transactions -->
            <li class="nav-item">
                <a href="{{ url('admin/transaction') }}" class="nav-link {{ request()->routeIs('admin.transaction') ? 'active' : '' }}">
                    <i class="link-icon" data-feather="activity"></i>
                    <span class="link-title">Transactions</span>
                </a>
            </li>

            <!-- Settings -->
            <li class="nav-item">
                <a class="nav-link" data-bs-toggle="collapse" href="#settings" role="button"
                   aria-expanded="{{ request()->routeIs('admin.setting.*') || request()->routeIs('admin.pages.*') || request()->routeIs('sliders.*') || request()->routeIs('menu.setting') || request()->routeIs('color.setting') ? 'true' : 'false' }}"
                   aria-controls="settings">
                    <i class="link-icon" data-feather="settings"></i>
                    <span class="link-title">Settings</span>
                    <i class="link-arrow" data-feather="chevron-down"></i>
                </a>
                <div class="collapse {{ request()->routeIs('admin.setting.*') || request()->routeIs('admin.pages.*') || request()->routeIs('sliders.*') || request()->routeIs('menu.setting') || request()->routeIs('color.setting') ? 'show' : '' }}" id="settings">
                    <ul class="nav sub-menu">
                        <li class="nav-item">
                            <a href="{{ route('admin.setting.index') }}" class="nav-link {{ request()->routeIs('admin.setting.index') ? 'active' : '' }}">
                                General Settings
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.pages.index') }}" class="nav-link {{ request()->routeIs('admin.pages.index') ? 'active' : '' }}">
                                Pages
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('sliders.index') }}" class="nav-link {{ request()->routeIs('sliders.index') ? 'active' : '' }}">
                                Manage Sliders
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('sliders.create') }}" class="nav-link {{ request()->routeIs('sliders.create') ? 'active' : '' }}">
                                Add Slider
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('menu.setting') }}" class="nav-link {{ request()->routeIs('menu.setting') ? 'active' : '' }}">
                                Menu Setting
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('color.setting') }}" class="nav-link {{ request()->routeIs('color.setting') ? 'active' : '' }}">
                                Color Setting
                            </a>
                        </li>

                        <li class="nav-item">
                            <a href="{{ route('admin.payment_gateways.index') }}" class="nav-link {{ request()->routeIs('admin.payment_gateways.index') ? 'active' : '' }}">
                                Gateway Setting 
                            </a>
                        </li>

                        <li class="nav-item">
                            <a href="{{ route('admin.payment_gateways.bkash') }}" class="nav-link {{ request()->routeIs('admin.payment_gateways.bkash') ? 'active' : '' }}">
                                Bkash Marchent Setting
                            </a>
                        </li>

                    </ul>
                </div>
            </li>

            <!-- Updates -->
            <li class="nav-item">
                <a href="{{ route('cron.jobs') }}" class="nav-link ">
                    <i class="link-icon" data-feather="refresh-cw"></i>
                    <span class="link-title">Cronjob</span>
                </a>
            </li>
            
           <!-- Updates --> 
<li class="nav-item">
    <a href="{{ route('update.system') }}" 
       onclick="return confirm('Are you sure you want to update the system?');">
       🔄 Update System (v{{ config('app.version') }})
    </a>
</li>

        </ul>
    </div>
</nav>