<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="description" content="green Responsive HTML Admin Dashboard Template based on Bootstrap 5">
    <meta name="author" content="green">
    <meta name="keywords" content=" bootstrap, bootstrap 5, admin, dashboard, template, responsive, css, sass, html, theme, front-end, ui kit, web">
    <title>Green Admin Panel</title>


 <!-- DataTables CSS -->
 {{-- <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap5.min.css"> --}}
 <link href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css" rel="stylesheet">


    <!-- Custom Styles -->
    <link rel="stylesheet" href="{{ url('/') }}/public/assets/backend/css/demo2/style.css">
    <link rel="stylesheet" href="{{ url('/') }}/public/assets/backend/vendors/select2/select2.min.css">
    <link rel="stylesheet" href="{{ url('/') }}/public/assets/backend/vendors/flatpickr/flatpickr.min.css">
    <link rel="stylesheet" href="{{ url('/') }}/public/assets/backend/fonts/feather-font/css/iconfont.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="{{ url('/') }}/public/assets/backend/vendors/flag-icon-css/css/flag-icon.min.css">
    <link rel="shortcut icon" href="{{ url('/') }}/public/assets/backend/images/favicon.png">
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.css">
</head>

<style>
    .dataTables_filter input {
        color: white; /* Change the text color */
        background-color: #333; /* Optional: Background color */
        border: 1px solid #555; /* Optional: Border color */
    }
</style>





<body>
    <div class="main-wrapper">
        @include('admin.body.sidebar')
        <div class="page-wrapper">
            @include('admin.body.header')
            @yield('admin')
            @include('admin.body.footer')
        </div>
    </div>
    








    <!-- Core JS IS jquery  -->
    <script src="{{ url('/') }}/public/assets/backend/vendors/core/core.js"></script>



<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>

<script>
    $(document).ready(function() {
        $('#dataTableExample').DataTable({
            responsive: true,
            paging: false, 
            searching: true,
            lengthChange: true
        });
    });
</script>






    <!-- Plugin JS -->
    <script src="{{ url('/') }}/public/assets/backend/vendors/flatpickr/flatpickr.min.js"></script>
    <script src="{{ url('/') }}/public/assets/backend/vendors/apexcharts/apexcharts.min.js"></script>

    <!-- Additional JS -->
    <script src="{{ url('/') }}/public/assets/backend/vendors/feather-icons/feather.min.js"></script>
    <script src="{{ url('/') }}/public/assets/backend/js/template.js"></script>
    <script src="{{ url('/') }}/public/assets/backend/js/dashboard-dark.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <script src="{{ url('/') }}/public/assets/backend/js/code/code.js"></script>


    <script src="{{ url('/') }}/public/assets/backend/vendors/select2/select2.min.js"></script>
    <script src="{{ url('/') }}/public/assets/backend/vendors/typeahead.js/typeahead.bundle.min.js"></script>
    <script src="{{ url('/') }}/public/assets/backend/js/select2.js"></script>
    <script src="{{ url('/') }}/public/assets/backend/vendors/tinymce/tinymce.min.js"></script>
    <script src="{{ url('/') }}/public/assets/backend/js/tinymce.js"></script>
    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>








    <script>
        @if (Session::has('message'))
            var type = "{{ Session::get('alert-type', 'info') }}";
            switch (type) {
                case 'info':
                    toastr.info(" {{ Session::get('message') }} ");
                    break;
                case 'success':
                    toastr.success(" {{ Session::get('message') }} ");
                    break;
                case 'warning':
                    toastr.warning(" {{ Session::get('message') }} ");
                    break;
                case 'error':
                    toastr.error(" {{ Session::get('message') }} ");
                    break;
            }
        @endif
    </script>





</body>
</html>
