<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class SettingsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            ['key' => 'site_title', 'value' => 'RexGaming BD | Trusted Top-Up Service'],
            ['key' => 'site_name', 'value' => 'RexGamingBD.com'],
            ['key' => 'currency', 'value' => '৳'],
            ['key' => 'meta_description', 'value' => 'rexgamingbd.com Trusted Online Gaming Topup Portal since 2018, Free Fire and PUBG mobile topup Bangladesh'],
            ['key' => 'meta_keywords', 'value' => 'free fire, pubg mobile, top up, unipin voucher, free fire diamonds, monthly membership, gaming topup Bangladesh'],
            ['key' => 'og_image', 'value' => 'public/upload/logo.png'],
            ['key' => 'twitter_image', 'value' => 'public/upload/logo.png'],
            ['key' => 'favicon', 'value' => 'public/upload/unipintopup.png'],
            ['key' => 'logo', 'value' => 'public/upload/logo.png'],
            ['key' => 'facebook_url', 'value' => 'https://facebook.com/rexgamingbd02'],
            ['key' => 'youtube_url', 'value' => 'https://www.youtube.com/@Teach99gamer'],
            ['key' => 'support_phone', 'value' => '+8801716720487'],
            ['key' => 'footer_email', 'value' => 'support@rexgamingbd.com'],
            ['key' => 'footer_copyright', 'value' => '© 2025 Rexgamingbd BD. All rights reserved.'],
            ['key' => 'notice_board', 'value' => 'Unipin Voucher ২৪ ঘন্টা অর্ডার করার সুযোগ! তবে UID টপআপ সকাল ৯.০০ থেকে রাত ১২.০০ টা পর্যন্ত উপলব্ধ থাকবে। সকল বাচ্চাদের কাছে আবেদন, দয়া করে বাবা মা অনুমতি ছাড়া অর্ডার করবেন না।'],
            ['key' => 'youtube_video', 'value' => 'https://gstopup.com'],
            ['key' => 'messenger_url', 'value' => 'https://gstopup.com'],
            ['key' => 'PopupText', 'value' => 'Test Popup'],
            ['key' => 'popup_enabled', 'value' => '1'],
            ['key' => 'addFund', 'value' => '/user/fund'],
            ['key' => 'home', 'value' => '/'],
            ['key' => 'myaccount', 'value' => '/user/dashboard'],
            ['key' => 'footer_info', 'value' => '#0F0161'],
            ['key' => 'content_heading_color', 'value' => '#FF5733'],
            ['key' => 'support_link_hover_color', 'value' => '#33FF57'],
            ['key' => 'nav_link_color', 'value' => '#FF5733'],
            ['key' => 'nav_link_hover_color', 'value' => '#F3920A'],
            ['key' => 'social_media_color', 'value' => '#FFFFFF'],
            ['key' => 'footer_rights_color', 'value' => '#FFFCFC'],
            ['key' => 'theme_color', 'value' => '#0F0161'],
            ['key' => 'logo_color', 'value' => '#FFFFFF'],
            ['key' => 'primary_font_color', 'value' => '#000000'],
            ['key' => 'navigation_background_color', 'value' => '#FFFFFF'],
            ['key' => 'navigation_font_color', 'value' => '#000000'],
            ['key' => 'footer_color', 'value' => '#080101'],
            ['key' => 'footer_font_color', 'value' => '#f0eded'],
            ['key' => 'content_box_color', 'value' => '#FFFFFF'],
            ['key' => 'notice_font_color', 'value' => '#FFFFFF'],
            ['key' => 'background_color', 'value' => '#010308'],
            ['key' => 'notice_background_color', 'value' => '#0F0161'],
            ['key' => 'short_description', 'value' => 'Rexgamingbd 2024 — This is a gaming platform that specializes in top-up services and gaming vouchers. 
               Join us for the best gaming experience!'],
            ['key' => 'telegram_support', 'value' => 'https://telegram.me/usdneed'],
            ['key' => 'auto_remove_order', 'value' => '30'],
            ['key' => 'custom_js', 'value' => 'custom_js'],
            ['key' => 'chat_enabled', 'value' => '1'],
            ['key' => 'whatsapp_message_api_enabled', 'value' => '1'],
            ['key' => 'whatsapp_message_api', 'value' => 'https://api.whatsapp.com/send?phone=8801716720487'],
            ['key' => 'whatsapp_sender_number', 'value' => '8801716720487'],
            ['key' => 'whatsapp_admin_number', 'value' => '8801716720487'],
            ['key' => 'bkash_username', 'value' => 'sandboxTokenizedUser02'],
            ['key' => 'bkash_password', 'value' => 'sandboxTokenizedUser02@12345'],
            ['key' => 'bkash_app_key', 'value' => '4f6o0cjiki2rfm34kfdadl1eqq'],
            ['key' => 'bkash_app_secret_key', 'value' => '2is7hdktrekvrbljjh44ll3d9l1dtjo4pasmjvs5vl5qr3fug4b'],
            ['key' => 'bkash_merchant_enable', 'value' => '1'],
            ['key' => 'bkash_sandbox', 'value' => '1'],
           
        ];

        // Insert or update the settings
        foreach ($settings as $setting) {
            DB::table('settings')->updateOrInsert(['key' => $setting['key']], $setting);
        }
    }
}
