<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->integer('order_sumid');
            $table->string('invoice_id')->nullable();
            $table->integer('product_id');
            $table->integer('variation_id');
            $table->integer('voucher_id')->nullable();
            $table->integer('single_price');

            $table->integer('total_price');
            $table->string('type');
            $table->integer('qty');
            $table->integer('status')->default(0); //0 pending, 1 processing, 2 complete, 3 cancelled
            $table->integer('auto_status')->default(0); //0 pending, 1 processing, 2 complete, 3 failed
            $table->text('notice')->nullable();
            $table->string('payment_type')->nullable();
            
            $table->string('player_id')->nullable();
            $table->string('automatic')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();

            $table->string('game_account_type')->nullable();
            $table->string('game_account')->nullable();
            $table->string('game_password')->nullable();
            $table->string('game_backup')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
