<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\View;

class CheckLicense
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    
    public function handle(Request $request, Closure $next): Response
    {
        // Retrieve the licensed host from the .env file  
        $licensedHost = parse_url('http://localhost/tipu/rexgamingbd/', PHP_URL_HOST);
        $licensedHost = preg_replace('/^www\./', '', strtolower($licensedHost));
    
        // Retrieve the current request host
        $currentHost = parse_url($request->fullUrl(), PHP_URL_HOST);
        $currentHost = preg_replace('/^www\./', '', strtolower($currentHost));
    
        // Log both hosts for debugging
       // Log::info("Checking license Issue Host - $licensedHost, Current Host - $currentHost");
    
        // Check if the current host matches the licensed host
        if ($currentHost !== $licensedHost) {
           // Log::warning("License mismatch detected. Current host ($currentHost) does not match licensed host ($licensedHost)");
            
            // Check if the license mismatch view exists
            if (View::exists('license.mismatch')) {
                Log::info("license.mismatch view found.");
                return response()->view('license.mismatch');
            } else {
                Log::warning("license.mismatch view NOT found.");
                return response('Invalid License', 403);
            }
        }

        // Proceed if license matches
        return $next($request);
    }
}
