<?php

namespace App\Http\Controllers\admin;

use Carbon\Carbon;
use App\Models\Payment;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TransactionController extends Controller
{
    public function transaction(Request $request)
    {
        $key = $request->key;
        $from = $request->from;
        $to = $request->to;
    
        $query = Payment::query()->with('user'); // Include user data
    
       
        // Search by any criteria (transaction_id, user name, or date)
    if (!empty($key)) {
        $query->where(function($query) use ($key) {
            $query->where('transaction_id', 'like', '%' . $key . '%')
                  ->orWhereHas('user', function($query) use ($key) {
                      $query->where('name', 'like', '%' . $key . '%');
                  });
        });
    }
    
        // Filter by date range if both from and to dates are provided
       if (!empty($from) && !empty($to)) {
        $query->whereBetween('created_at', [
            Carbon::parse($from)->startOfDay(),
            Carbon::parse($to)->endOfDay()
        ]);
    }
    
        // Order by the latest entries and paginate
        $payments = $query->orderBy('id', 'desc')->paginate(10);
    
        return view('admin.transaction.transaction_list', compact('payments'));
    }
    
}
