<?php

namespace App\Http\Controllers\admin;

use App\Models\Order;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;

class OrderController extends Controller
{
   
    
        public function PaidOrder(Request $request)
        {
            $paidOrders = Order::where('auto_status', 2)
            ->orWhere('status', 2) 
                ->with(['autoTopup'])
                ->orderBy('id', 'DESC') // ✅ Order by latest first
                ->orderByDesc('created_at') // ✅ Order by latest created_at
                ->paginate(20);
              
            return view('admin.order.paidOrders_list', compact('paidOrders'));
        }
        


        public function ProssesingOrder(Request $request)
        {
            $paidOrders = Order::where('status',1)
                ->with(['autoTopup'])
                ->orderBy('id', 'DESC') // ✅ Order by latest first
                ->orderByDesc('created_at') // ✅ Order by latest created_at
                ->paginate(20);
              
            return view('admin.order.prossesing_order_list', compact('paidOrders'));
        }
        

    


    public function index() {
        // $orders = Order::orderBy('id', 'DESC')->paginate(5); 

        //$orders = Order::latest()->paginate(5);

     // Fetch orders where auto_status or status is 3
     $orders = Order::where('status', 3)
     ->orWhere('status', 0)
     ->orderBy('id', 'DESC')
     ->paginate(5);
   
        return view('admin.order.cancelled_order_list', compact('orders'));
    }

    public function PendingOrder() {
        // $orders = Order::orderBy('id', 'DESC')->paginate(5); 

        //$orders = Order::latest()->paginate(5);

     // Fetch orders where auto_status or status is 3
     $orders = Order::where('status', 0)
     ->orWhere('status', 0)
     ->orderBy('id', 'DESC')
     ->paginate(5);
   
        return view('admin.order.pending_order_list', compact('orders'));
    }


   
    public function DeletePaidOrders($id)
    {


        try {
            $order = Order::findOrFail($id); // Ensure the order exists
            $order->delete(); // Delete the order
   

            Log::info('Order deleted successfully', ['order' => $order]);
            
            return redirect()->back()->with('success', '✅ Order deleted successfully!');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', '❌ Failed to delete order.');
        }
    }
   
   
    

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {

    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $order = Order::find($id);
        return view('admin.order.order_edit', compact('order'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
{
    $this->validate($request, [
        'status' => 'required_without:auto_status',
        'auto_status' => 'required_without:status',
    ]);

    $order = Order::find($id);

    if (!$order) {
        return redirect('admin/paid/order')->with('error', 'Order not found.');
    }

    // Update based on order type
    if ($order->automatic) {
        $order->auto_status = $request->auto_status;
    } else {
        $order->status = $request->status;
    }

    $order->notice = $request->notice;
    $order->save();

    return redirect('admin/paid/order')->with('success', 'Order updated successfully.');
}


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        // Find the order by its ID
        $order = Order::find($id);
    
        if ($order) {
            // Delete the order
            $order->delete();
            return redirect()->route('admin.order.index')->with('success', 'Order deleted successfully.');
        } else {
            return redirect()->route('admin.order.index')->with('error', 'Order not found.');
        }
    }
}
