<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Order;
use App\Models\Orderitem;
use GuzzleHttp\Client;
use App\Models\Payment;
use App\Models\Voucher;
use App\Models\Variation;
use App\Models\Uddoktapay;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\PaymentGateway;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;

class UddoktapayController extends Controller
{
    public function pay()
    {
        // 83353552
        // 01780481585
        // https://uddoktapay.readme.io/reference/create-charge
    }

   // before voucer  auto order insert

    // public function success(Request $request)
    // {
    //     // Fetch payment gateway configuration from the database
    //     $UddoktaPay = PaymentGateway::where('type', 'uddoktapay')->first();
    //     $paymentId = session()->get('payment_idx');

    //     // Check if the payment gateway is found and is active
    //     if ($UddoktaPay && $UddoktaPay->is_active == 1 && $paymentId != null) {

    //         $payment = Payment::find($paymentId);
    //         $payment->payment_status = 'completed';
    //         $payment->save();

    //         try {

    //             // Get the API URL and Key from the database
    //             $apiUrl = $UddoktaPay->base_url;
    //             $apiKey = $UddoktaPay->api_key;

    //             // Create a Guzzle client
    //             $client = new Client();

    //             // Make the POST request to the API
    //             $response = $client->request('POST',   $apiUrl . 'api/verify-payment', [
    //                 'headers' => [
    //                     'RT-UDDOKTAPAY-API-KEY' => $apiKey,
    //                     'accept' => 'application/json',
    //                     'content-type' => 'application/json',
    //                 ],
    //                 'json' => [
    //                     'invoice_id' => $request->invoice_id, // Pass the invoice_id in the request body
    //                 ],
    //             ]);

    //             // Get the response body
    //             $body = $response->getBody()->getContents();
    //             $data = json_decode($body, true);

    //             // Save the payment gateway data into the database
    //             $uddoktapay = new Uddoktapay();
    //             $uddoktapay->user_id = Auth::user()->id;
    //             $uddoktapay->invoice_id = $request->invoice_id;
    //             $uddoktapay->amount = $data['amount'];
    //             $uddoktapay->status = $data['status'];
    //             $uddoktapay->save();

    //             // Handle payment status and update wallet or order
    //             if ($data['status'] == 'COMPLETED') {
    //                 // Handle wallet update or order status update as necessary
    //                 if ($data['metadata']['order_id'] == null) {
    //                     $user = User::find(Auth::user()->id);
    //                     $user->balance += $data['amount'];
    //                     $user->save();
    //                 } else {
    //                     // Handle orders here
    //                     $orders = Order::where('order_sumid', $data['metadata']['order_id'])->get();
    //                     foreach ($orders as $order) {
                            
    //                         //$order->status = $order->type == 'topup' ? 1 : '2';
    //                         // My ingame condition added Ridoy
    //                         $order->status = $order->type == 'topup' || $order->type == 'ingame' ? 1 : 2;

    //                         $order->invoice_id = $request->invoice_id; // Save the invoice_id
    //                         $order->save();


    //                         // Update voucher status
    //                         $voucher = Voucher::find($order->voucher_id);
    //                         if (isset($voucher)) {
    //                             $voucher->status = 1;
    //                             $order->payment_type = 'wallet';
    //                             $voucher->save();
    //                         }

    //                         $variation = Variation::find($order->variation_id);
    //                         $variation->stock = $variation->stock - 1;
    //                         $variation->save();
    //                     }

    //                     // Redirect to the appropriate page based on order type
    //                     $order = Order::where('order_sumid', $data['metadata']['order_id'])->first();
    //                     if ($order->type == 'voucher') {
    //                         return redirect('user/voucher')->with('success', 'Payment successfully processed, wallet updated');
    //                     }
    //                 }

    //                 return redirect('user/orders')->with('success', 'Payment successfully processed, wallet updated');
    //             }

    //             return redirect('user/dashboard')->with('error', 'Payment failed');
    //         } catch (\Exception $e) {
    //             return response()->json(
    //                 [
    //                     'success' => false,
    //                     'message' => $e->getMessage(),
    //                 ],
    //                 500,
    //             );
    //         }
    //     }

    //     // Handle case where payment gateway is inactive or not found
    //     return redirect('user/dashboard')->with('error', 'Payment Gateway is not active or not found.');
    // }

// 2nd method
    // public function success(Request $request)
    // {
    //     // পেমেন্ট গেটওয়ে কনফিগারেশন লোড করা
    //     $UddoktaPay = PaymentGateway::where('type', 'uddoktapay')->first();
    //     $paymentId = session()->get('payment_idx');

    //     // গেটওয়ে চেক এবং পেমেন্ট আইডি আছে কি না
    //     if ($UddoktaPay && $UddoktaPay->is_active == 1 && $paymentId != null) {
    //         $payment = Payment::find($paymentId);
    //         $originalAmount = $payment->amount; // ইউজারের দেওয়া অরিজিনাল অ্যামাউন্ট

    //         // পেমেন্ট স্ট্যাটাস আপডেট
    //         $payment->payment_status = 'completed';
    //         $payment->save();

    //         try {
    //             // API URL এবং কী লোড করা
    //             $apiUrl = $UddoktaPay->base_url;
    //             $apiKey = $UddoktaPay->api_key;

    //             // Guzzle ক্লায়েন্ট দিয়ে API কল
    //             $client = new Client();
    //             $response = $client->request('POST', $apiUrl . 'api/verify-payment', [
    //                 'headers' => [
    //                     'RT-UDDOKTAPAY-API-KEY' => $apiKey,
    //                     'accept' => 'application/json',
    //                     'content-type' => 'application/json',
    //                 ],
    //                 'json' => [
    //                     'invoice_id' => $request->invoice_id, // ইনভয়েস আইডি
    //                 ],
    //             ]);

    //             // API থেকে রেসপন্স পাওয়া
    //             $body = $response->getBody()->getContents();
    //             $data = json_decode($body, true);

    //             // ডিবাগিং-এর জন্য লগিং
    //             Log::info('UddoktaPay Response: ' . json_encode($data) . ', Original Amount: ' . $originalAmount);

    //             // যদি অ্যামাউন্টে অমিল থাকে তাহলে ওয়ার্নিং লগ
    //             if ($data['amount'] != $originalAmount) {
    //                 Log::warning('Amount Mismatch: Expected ' . $originalAmount . ', Got ' . $data['amount']);
    //             }
    //             if ($data['charged_amount'] != $originalAmount) {
    //                 Log::warning('Charged Amount Mismatch: Expected ' . $originalAmount . ', Got ' . $data['charged_amount']);
    //             }

    //             // Uddoktapay টেবিলে ডাটা সেভ
    //             $uddoktapay = new Uddoktapay();
    //             $uddoktapay->user_id = Auth::user()->id;
    //             $uddoktapay->invoice_id = $request->invoice_id;
    //             $uddoktapay->amount = $data['amount'];
    //             $uddoktapay->status = $data['status'];
    //             $uddoktapay->save();

    //             // পেমেন্ট সফল হলে
    //             if ($data['status'] == 'COMPLETED') {
    //                 if ($data['metadata']['order_id'] == null) {
    //                     // অর্ডার না থাকলে ব্যালেন্সে যোগ করা
    //                     $user = User::find(Auth::user()->id);
    //                     $user->balance += $originalAmount; // অরিজিনাল অ্যামাউন্ট যোগ করুন, গেটওয়ের নয়
    //                     $user->save();
    //                     Log::info('Balance Updated: User ID ' . $user->id . ', Added Amount: ' . $originalAmount);
    //                 } else {
    //                     // অর্ডার থাকলে অর্ডার আপডেট
    //                     $orders = Order::where('order_sumid', $data['metadata']['order_id'])->get();
    //                     foreach ($orders as $order) {
    //                         $order->status = $order->type == 'topup' || $order->type == 'ingame' ? 1 : 2;
    //                         $order->invoice_id = $request->invoice_id;
    //                         $order->save();

    //                         // ভাউচার আপডেট
    //                         $voucher = Voucher::find($order->voucher_id);
    //                         if (isset($voucher)) {
    //                             $voucher->status = 1;
    //                             $order->payment_type = 'wallet';
    //                             $voucher->save();
    //                         }

    //                         // ভেরিয়েশন স্টক কমানো
    //                         $variation = Variation::find($order->variation_id);
    //                         $variation->stock = $variation->stock - 1;
    //                         $variation->save();
    //                     }

    //                     // রিডাইরেক্টের জন্য অর্ডার টাইপ চেক
    //                     $order = Order::where('order_sumid', $data['metadata']['order_id'])->first();
    //                     if ($order->type == 'voucher') {
    //                         return redirect('user/voucher')->with('success', 'Payment successfully processed, wallet updated');
    //                     }
    //                 }

    //                 return redirect('user/dashboard')->with('success', 'Payment successfully processed, wallet updated');
    //             }

    //             return redirect('user/dashboard')->with('error', 'Payment failed');
    //         } catch (\Exception $e) {
    //             Log::error('Payment Error: ' . $e->getMessage());
    //             return response()->json(
    //                 [
    //                     'success' => false,
    //                     'message' => $e->getMessage(),
    //                 ],
    //                 500
    //             );
    //         }
    //     }

    //     return redirect('user/dashboard')->with('error', 'Payment Gateway is not active or not found.');
    // }


// 3rd method

// public function success(Request $request)
//     {
//         $UddoktaPay = PaymentGateway::where('type', 'uddoktapay')->first();
//         $paymentId = session()->get('payment_idx');

//         if ($UddoktaPay && $UddoktaPay->is_active == 1 && $paymentId != null) {
//             $payment = Payment::find($paymentId);
//             $payment->payment_status = 'completed';
//             $payment->save();

//             try {
//                 $apiUrl = $UddoktaPay->base_url;
//                 $apiKey = $UddoktaPay->api_key;

//                 $client = new Client();
//                 $response = $client->request('POST', $apiUrl . 'api/verify-payment', [
//                     'headers' => [
//                         'RT-UDDOKTAPAY-API-KEY' => $apiKey,
//                         'accept' => 'application/json',
//                         'content-type' => 'application/json',
//                     ],
//                     'json' => [
//                         'invoice_id' => $request->invoice_id,
//                     ],
//                 ]);

//                 $body = $response->getBody()->getContents();
//                 $data = json_decode($body, true);

//                 Log::info('UddoktaPay Response: ' . json_encode($data) . ', Payment ID: ' . $paymentId);

//                 $uddoktapay = new Uddoktapay();
//                 $uddoktapay->user_id = Auth::user()->id;
//                 $uddoktapay->invoice_id = $request->invoice_id;
//                 $uddoktapay->amount = $data['amount'];
//                 $uddoktapay->status = $data['status'];
//                 $uddoktapay->save();

//                 if ($data['status'] == 'COMPLETED') {
//                     // অর্ডারগুলো আপডেট
//                     $orders = Order::where('order_sumid', $data['metadata']['order_id'])->get();
//                     foreach ($orders as $order) {
//                         // ভাউচার যোগ
//                         if (!$order->voucher_id) {
//                             $voucher = Voucher::where('variation', $order->variation_id)
//                                 ->where('status', 0)
//                                 ->first();
//                             if ($voucher) {
//                                 $voucher->status = 1;
//                                 $voucher->save();
//                                 $order->voucher_id = $voucher->id;
//                                 $order->automatic = $voucher->automatic;
//                                 Log::info('Voucher Added: Order ID ' . $order->id . ', Voucher ID: ' . $voucher->id);
//                             } else {
//                                 Log::warning('No voucher available for Order ID ' . $order->id);
//                             }
//                         }

//                         // স্ট্যাটাস আপডেট
//                         $order->status = $order->type == 'topup' || $order->type == 'ingame' ? 1 : 2;
//                         $order->invoice_id = $request->invoice_id;
//                         $order->save();

//                         // স্টক কমানো
//                         $variation = Variation::find($order->variation_id);
//                         if ($variation) {
//                             $variation->stock = $variation->stock - 1;
//                             $variation->save();
//                             Log::info('Stock Updated: Variation ID ' . $variation->id . ', New Stock: ' . $variation->stock);
//                         }
//                     }

//                     // ব্যালেন্সে টাকা যোগ (যদি অর্ডার না থাকে)
//                     if ($data['metadata']['order_id'] == null) {
//                         $user = User::find(Auth::user()->id);
//                         $user->balance += $data['amount'];
//                         $user->save();
//                         Log::info('Balance Updated: User ID ' . $user->id . ', Added Amount: ' . $data['amount']);
//                     }

//                     // রিডাইরেক্ট
//                     $order = Order::where('order_sumid', $data['metadata']['order_id'])->first();
//                     if ($order && $order->type == 'voucher') {
//                         return redirect('user/voucher')->with('success', 'Payment successfully processed, wallet updated');
//                     }
//                     return redirect('user/dashboard')->with('success', 'Payment successfully processed, wallet updated');
//                 }

//                 return redirect('user/dashboard')->with('error', 'Payment failed');
//             } catch (\Exception $e) {
//                 Log::error('Payment Error: ' . $e->getMessage());
//                 return response()->json([
//                     'success' => false,
//                     'message' => $e->getMessage(),
//                 ], 500);
//             }
//         }

//         return redirect('user/dashboard')->with('error', 'Payment Gateway is not active or not found.');
//     }


// version 4  with order items 

// public function success(Request $request)
// {
//     $UddoktaPay = PaymentGateway::where('type', 'uddoktapay')->first();
//     $paymentId = session()->get('payment_idx');

//     if ($UddoktaPay && $UddoktaPay->is_active == 1 && $paymentId != null) {
//         $payment = Payment::find($paymentId);
//         $payment->payment_status = 'completed';
//         $payment->save();

//         try {
//             $apiUrl = $UddoktaPay->base_url;
//             $apiKey = $UddoktaPay->api_key;

//             $client = new \GuzzleHttp\Client();
//             $response = $client->request('POST', $apiUrl . 'api/verify-payment', [
//                 'headers' => [
//                     'RT-UDDOKTAPAY-API-KEY' => $apiKey,
//                     'accept' => 'application/json',
//                     'content-type' => 'application/json',
//                 ],
//                 'json' => [
//                     'invoice_id' => $request->invoice_id,
//                 ],
//             ]);

//             $body = $response->getBody()->getContents();
//             $data = json_decode($body, true);

//             Log::info('UddoktaPay Response: ' . json_encode($data) . ', Payment ID: ' . $paymentId);

//             $uddoktapay = new Uddoktapay();
//             $uddoktapay->user_id = Auth::user()->id;
//             $uddoktapay->invoice_id = $request->invoice_id;
//             $uddoktapay->amount = $data['amount'];
//             $uddoktapay->status = $data['status'];
//             $uddoktapay->save();

//             if ($data['status'] == 'COMPLETED') {
//                 $order = Order::where('order_sumid', $data['metadata']['order_id'])->first();
//                 if ($order) {
//                     $orderItems = $order->items;
//                     if ($orderItems && $orderItems->isNotEmpty()) {
//                         $existingItem = $orderItems->first();
//                         if ($order->type == 'voucher' && !$existingItem->voucher_id) {
//                             $quantity = $existingItem->quantity;
//                             $variation = Variation::find($order->variation_id);
//                             $usedVoucherIds = [];

//                             for ($i = 0; $i < $quantity; $i++) {
//                                 $voucher = Voucher::where('variation', $order->variation_id)
//                                     ->where('status', 0)
//                                     ->first();
//                                 if ($voucher) {
//                                     $voucher->status = 1;
//                                     $voucher->save();
//                                     $usedVoucherIds[] = $voucher->id;

//                                     $orderItem = new OrderItem();
//                                     $orderItem->order_id = $order->id;
//                                     $orderItem->voucher_id = $voucher->id;
//                                     $orderItem->quantity = 1;
//                                     $orderItem->single_price = $variation->price;
//                                     $orderItem->total_price = $variation->price;
//                                     $orderItem->save();

//                                     Log::info('Voucher Added: Order ID ' . $order->id . ', Voucher ID: ' . $voucher->id);
//                                 } else {
//                                     Log::warning('No voucher available for Order ID ' . $order->id);
//                                     break;
//                                 }
//                             }

//                             if (!empty($usedVoucherIds)) {
//                                 $existingItem->delete();
//                                 if ($variation) {
//                                     $variation->stock -= count($usedVoucherIds);
//                                     $variation->save();
//                                     Log::info('Stock Updated: Variation ID ' . $variation->id . ', New Stock: ' . $variation->stock);
//                                 }
//                             }
//                         }
//                     } else {
//                         Log::warning('No OrderItems found for Order ID ' . $order->id);
//                     }

//                     // Update order status for all types
//                     $order->status = ($order->type == 'topup' || $order->type == 'ingame') ? 1 : 2;
//                     $order->invoice_id = $request->invoice_id;
//                     $order->save();

//                     return redirect($order->type == 'voucher' ? 'user/voucher' : 'user/dashboard')
//                         ->with('success', 'Payment successfully processed');
//                 } else {
//                     $user = User::find(Auth::user()->id);
//                     $previous_balance = $user->balance;
//                     $user->balance += $data['amount'];
//                     $user->save();
//                     $new_balance = $user->balance;
//                     Log::info('Balance Updated: User ID ' . $user->id . ', Added Amount: ' . $data['amount']);

//                     Transaction::create([
//                         'user_id' => $user->id,
//                         'previous_balance' => $previous_balance,
//                         'amount' => $data['amount'],
//                         'new_balance' => $new_balance,
//                         'transaction_id' => $payment->transaction_id,
//                         'payment_status' => 'completed',
//                     ]);
//                     return redirect('user/dashboard')->with('success', 'Payment successfully');
//                 }
//             }

//             return redirect('user/dashboard')->with('error', 'Payment failed');
//         } catch (\Exception $e) {
//             Log::error('Payment Error: ' . $e->getMessage());
//             return response()->json([
//                 'success' => false,
//                 'message' => $e->getMessage(),
//             ], 500);
//         }
//     }

//     return redirect('user/dashboard')->with('error', 'Payment Gateway is not active or not found.');
// }


// 5 version 

public function success(Request $request)
{
    $UddoktaPay = PaymentGateway::where('type', 'uddoktapay')->first();
    $paymentId = session()->get('payment_idx');

    if ($UddoktaPay && $UddoktaPay->is_active == 1 && $paymentId != null) {
        $payment = Payment::find($paymentId);
        
        // Check if payment already processed
        if ($payment->payment_status == 'completed') {
            return redirect('user/dashboard')->with('info', 'This payment has already been processed.');
        }
        
        $payment->payment_status = 'completed';
        $payment->save();

        try {
            $apiUrl = $UddoktaPay->base_url;
            $apiKey = $UddoktaPay->api_key;

            // Check if this invoice_id has already been processed
            $existingTransaction = Uddoktapay::where('invoice_id', $request->invoice_id)
                                             ->where('status', 'COMPLETED')
                                             ->first();
            
            if ($existingTransaction) {
                Log::warning('Duplicate payment attempt: ' . $request->invoice_id);
                return redirect('user/dashboard')->with('info', 'This payment has already been processed.');
            }

            $client = new \GuzzleHttp\Client();
            $response = $client->request('POST', $apiUrl . 'api/verify-payment', [
                'headers' => [
                    'RT-UDDOKTAPAY-API-KEY' => $apiKey,
                    'accept' => 'application/json',
                    'content-type' => 'application/json',
                ],
                'json' => [
                    'invoice_id' => $request->invoice_id,
                ],
            ]);

            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);

            Log::info('UddoktaPay Response: ' . json_encode($data) . ', Payment ID: ' . $paymentId);

            // Check if this transaction is already in our database
            $existingTransaction = Uddoktapay::where('invoice_id', $request->invoice_id)->first();
            if (!$existingTransaction) {
                $uddoktapay = new Uddoktapay();
                $uddoktapay->user_id = Auth::user()->id;
                $uddoktapay->invoice_id = $request->invoice_id;
                $uddoktapay->amount = $data['amount'];
                $uddoktapay->status = $data['status'];
                $uddoktapay->save();
            } else {
                Log::warning('Duplicate transaction prevented: ' . $request->invoice_id);
                return redirect('user/dashboard')->with('info', 'This payment has already been processed.');
            }

            if ($data['status'] == 'COMPLETED') {
                $order = Order::where('order_sumid', $data['metadata']['order_id'])->first();
                if ($order) {
                    // Check if order is already processed
                    if ($order->status > 0) {
                        Log::warning('Order already processed: ' . $order->id);
                        return redirect($order->type == 'voucher' ? 'user/voucher' : 'user/dashboard')
                            ->with('info', 'This order has already been processed.');
                    }
                    
                    $orderItems = $order->items;
                    if ($orderItems && $orderItems->isNotEmpty()) {
                        $existingItem = $orderItems->first();
                        if ($order->type == 'voucher' && !$existingItem->voucher_id) {
                            $quantity = $existingItem->quantity;
                            $variation = Variation::find($order->variation_id);
                            $usedVoucherIds = [];

                            for ($i = 0; $i < $quantity; $i++) {
                                $voucher = Voucher::where('variation', $order->variation_id)
                                    ->where('status', 0)
                                    ->first();
                                if ($voucher) {
                                    $voucher->status = 1;
                                    $voucher->save();
                                    $usedVoucherIds[] = $voucher->id;

                                    $orderItem = new OrderItem();
                                    $orderItem->order_id = $order->id;
                                    $orderItem->voucher_id = $voucher->id;
                                    $orderItem->quantity = 1;
                                    $orderItem->single_price = $variation->price;
                                    $orderItem->total_price = $variation->price;
                                    $orderItem->save();

                                    Log::info('Voucher Added: Order ID ' . $order->id . ', Voucher ID: ' . $voucher->id);
                                } else {
                                    Log::warning('No voucher available for Order ID ' . $order->id);
                                    break;
                                }
                            }

                            if (!empty($usedVoucherIds)) {
                                $existingItem->delete();
                                if ($variation) {
                                    $variation->stock -= count($usedVoucherIds);
                                    $variation->save();
                                    Log::info('Stock Updated: Variation ID ' . $variation->id . ', New Stock: ' . $variation->stock);
                                }
                            }
                        }
                    } else {
                        Log::warning('No OrderItems found for Order ID ' . $order->id);
                    }

                    // Update order status for all types
                    $order->status = ($order->type == 'topup' || $order->type == 'ingame') ? 1 : 2;
                    $order->invoice_id = $request->invoice_id;
                    $order->save();

                    return redirect($order->type == 'voucher' ? 'user/voucher' : 'user/dashboard')
                        ->with('success', 'Payment successfully processed');
                } else {
                    $user = User::find(Auth::user()->id);
                    
                    // Check if a transaction with this invoice_id already exists
                    $existingTransaction = Transaction::where('transaction_id', $payment->transaction_id)
                                                    ->where('payment_status', 'completed')
                                                    ->first();
                    if ($existingTransaction) {
                        Log::warning('Duplicate transaction prevented for user: ' . $user->id . ', Invoice: ' . $request->invoice_id);
                        return redirect('user/dashboard')->with('info', 'This payment has already been processed.');
                    }
                    
                    $previous_balance = $user->balance;
                    $user->balance += $data['amount'];
                    $user->save();
                    $new_balance = $user->balance;
                    Log::info('Balance Updated: User ID ' . $user->id . ', Added Amount: ' . $data['amount']);

                    Transaction::create([
                        'user_id' => $user->id,
                        'previous_balance' => $previous_balance,
                        'amount' => $data['amount'],
                        'new_balance' => $new_balance,
                        'transaction_id' => $payment->transaction_id,
                        'payment_status' => 'completed',
                    ]);
                    return redirect('user/dashboard')->with('success', 'Payment successfully processed');
                }
            }

            return redirect('user/dashboard')->with('error', 'Payment failed');
        } catch (\Exception $e) {
            Log::error('Payment Error: ' . $e->getMessage());
            return response()->json([
                'success' => false,
                'message' => $e->getMessage(),
            ], 500);
        }
    }

    return redirect('user/dashboard')->with('error', 'Payment Gateway is not active or not found.');
}

    public function cancel(Request $request)
    {
        return redirect('user/dashboard')->with('error', 'Payment failed');
    }

    public function webhook(Request $request)
    {
        return $request;
    }
}
