<?php

namespace App\Http\Controllers;

use Hash;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Laravel\Socialite\Facades\Socialite;

class GoogleLoginController extends Controller
{
    public function redirectToGoogle()
    {
        return Socialite::driver('google')->redirect();
    }

    public function handleGoogleCallback()
    {
        $googleUser = Socialite::driver('google')->stateless()->user();
    
        // Check if the user exists by email
        $user = User::where('email', $googleUser->email)->first();
    
        if (!$user) {
            // Create a new user without 'type' in create and set 'type' separately
            $user = User::create([
                'name' => $googleUser->name,
                'email' => $googleUser->email,
                'password' => Hash::make(rand(100000, 999999)),
                'phone' => null,
                'photo' => $googleUser->avatar ?? null,
                'status' => 1,
                'balance' => 0
            ]);
    
            // Set the 'type' attribute after creation if needed
            $user->type = 'user';
            $user->save();
        }
    
        // Log the user in
        Auth::login($user);
    
        // Redirect to dashboard
        return redirect('/user/dashboard');
    }

}
