<?php

namespace App\Http\Controllers;

use App\Models\Drutopay;
use App\Models\Order;
use Illuminate\Http\Request;
use App\Models\PaymentGateway;
use App\Models\User;
use App\Models\Variation;
use App\Models\Voucher;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;

class DrutopayController extends Controller
{
    public function pay(Request $request){
    }



   // before voucer  auto order insert
// public function success(Request $request)
//     {

//         $drutopay = PaymentGateway::where('type', 'drutopay')->first();

//         $curl = curl_init();

//         curl_setopt_array($curl, [
//             CURLOPT_URL => 'https://pay.drutopay.com/api/payment/verify',
//             CURLOPT_RETURNTRANSFER => true,
//             CURLOPT_ENCODING => '',
//             CURLOPT_MAXREDIRS => 10,
//             CURLOPT_TIMEOUT => 0,
//             CURLOPT_FOLLOWLOCATION => true,
//             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//             CURLOPT_CUSTOMREQUEST => 'POST',
//             CURLOPT_POSTFIELDS => '{"transaction_id":"'.$request->transactionId.'"}',
//             CURLOPT_HTTPHEADER => ['API-KEY: '.$drutopay->api_key, 'Content-Type: application/json', 'SECRET-KEY: '.$drutopay->secret, 'BRAND-KEY: '.$drutopay->client],
//         ]);

//         $response = curl_exec($curl);

//         curl_close($curl);

//         $data = json_decode($response, true);
//         $status = $data['status'] ?? 'Unknown';

//         $ckpay = Drutopay::where('tr_id', $request->transactionId)->first();

//         if ($status == 'COMPLETED' && !isset($ckpay)) {
//             $drutopay = new Drutopay();
//             $drutopay->user_id = Auth::user()->id;
//             $drutopay->tr_id = $request->transactionId;
//             $drutopay->status = $status;
//             $drutopay->save();

//             $order_sumid = session()->get('order_sumid');

//             if ($order_sumid == null) {
//                 $user = User::find(Auth::user()->id);
//                 $user->balance = $user->balance + $request->paymentAmount;
//                 $user->save();

//                 return redirect('user/dashboard')->with('success', 'Payment successfully processed, wallet updated');
//             } else {
//                 $myorders = Order::where('order_sumid', $order_sumid)->get();

//                 foreach ($myorders as $myorder) {
//                     //$myorder->status = $myorder->type == 'topup' ? 1 : '2';
//                         // My ingame condition added Ridoy
//                     $myorder->status = $myorder->type == 'topup' || $myorder->type == 'ingame' ? 1 : 2;


//                     $voucher = Voucher::find($myorder->voucher_id);
//                     if (isset($voucher)) {
//                         $voucher->status = 1;
//                         $myorder->payment_type = 'drutopay';
//                         $voucher->save();
//                     }
//                     $myorder->save();

//                     $variation = Variation::find($myorder->variation_id);
//                     $variation->stock = $variation->stock - 1;
//                     $variation->save();
//                 }

//                 // Redirect to the appropriate page based on order type
//                 $order = Order::where('order_sumid', session()->get('order_sumid'))->first();
//                 session()->forget('order_sumid');
//                 if ($order->type == 'voucher') {
//                     return redirect('user/voucher')->with('success', 'Payment successfully processed, wallet updated');
//                 }

//                 return redirect('user/orders')->with('success', 'Payment successfully processed, wallet updated');
//             }
//         }

//         return redirect('user/dashboard')->with('error', 'Something went wrong');
//     }


public function success(Request $request)
{
    $drutopay = PaymentGateway::where('type', 'drutopay')->first();

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://pay.drutopay.com/api/payment/verify',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => '{"transaction_id":"' . $request->transactionId . '"}',
        CURLOPT_HTTPHEADER => [
            'API-KEY: ' . $drutopay->api_key,
            'Content-Type: application/json',
            'SECRET-KEY: ' . $drutopay->secret,
            'BRAND-KEY: ' . $drutopay->client
        ],
    ]);

    $response = curl_exec($curl);
    curl_close($curl);

    $data = json_decode($response, true);
    $status = $data['status'] ?? 'Unknown';

    $ckpay = Drutopay::where('tr_id', $request->transactionId)->first();

    if ($status == 'COMPLETED' && !$ckpay) {
        $drutopayRecord = new Drutopay();
        $drutopayRecord->user_id = Auth::user()->id;
        $drutopayRecord->tr_id = $request->transactionId;
        $drutopayRecord->status = $status;
        $drutopayRecord->save();

        $order_sumid = session()->get('order_sumid');

        if ($order_sumid) {
            $orders = Order::where('order_sumid', $order_sumid)->get();
            foreach ($orders as $order) {
                // ভাউচার যোগ
                if (!$order->voucher_id) {
                    $voucher = Voucher::where('variation', $order->variation_id)
                        ->where('status', 0)
                        ->first();
                    if ($voucher) {
                        $voucher->status = 1;
                        $voucher->save();
                        $order->voucher_id = $voucher->id;
                        $order->automatic = $voucher->automatic;
                        Log::info('Voucher Added: Order ID ' . $order->id . ', Voucher ID: ' . $voucher->id);
                    } else {
                        Log::warning('No voucher available for Order ID ' . $order->id);
                    }
                }

                // স্ট্যাটাস আপডেট
                $order->status = $order->type == 'topup' || $order->type == 'ingame' ? 1 : 2;
                $order->save();

                // স্টক কমানো
                $variation = Variation::find($order->variation_id);
                if ($variation) {
                    $variation->stock -= 1;
                    $variation->save();
                    Log::info('Stock Updated: Variation ID ' . $variation->id . ', New Stock: ' . $variation->stock);
                }
            }

            $order = Order::where('order_sumid', $order_sumid)->first();
            session()->forget('order_sumid');
            if ($order->type == 'voucher') {
                return redirect('user/voucher')->with('success', 'Payment successfully processed, wallet updated');
            }
            return redirect('user/orders')->with('success', 'Payment successfully processed, wallet updated');
        } else {
            // অর্ডার না থাকলে ব্যালেন্সে টাকা যোগ
            $user = User::find(Auth::user()->id);
            $user->balance += $request->paymentAmount;
            $user->save();
            Log::info('Balance Updated: User ID ' . $user->id . ', Added Amount: ' . $request->paymentAmount);

            return redirect('user/dashboard')->with('success', 'Payment successfully processed, wallet updated');
        }
    }

    return redirect('user/dashboard')->with('error', 'Something went wrong');
}


    public function cancel(Request $request)
    {
        return redirect('user/dashboard')->with('error', 'Payment cancelled successfully');
    }
}
